<?php
/*
Plugin Name: SocialFeeds pro
Description: Advanced YouTube and Instagram feeds for WordPress with easy Get Started and Settings options.
Version: 1.0.3
Author: Softaculous
Author URI: https://softaculous.com/
Text Domain: socialfeeds-pro
*/

if(!defined('ABSPATH')){
	exit;
}

if(!function_exists('add_action')){
	echo 'You are not allowed to access this page directly.';
	exit;
}

//SOCIALFEEDS
define('SOCIALFEEDS_PRO_VERSION', '1.0.3');
define('SOCIALFEEDS_PRO_FILE', __FILE__);
define('SOCIALFEEDS_PRO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('SOCIALFEEDS_PRO_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SOCIALFEEDS_API', 'https://a.softaculous.com/socialfeeds');

include_once SOCIALFEEDS_PRO_PLUGIN_DIR . 'functions.php';

function socialfeeds_pro_autoloader($class){
	if(!preg_match('/^SocialFeedsPro\\\(.*)/is', $class, $m)){
		return;
	}

	$m[1] = str_replace('\\', '/', $m[1]);

	// Include file
	if(file_exists(SOCIALFEEDS_PRO_PLUGIN_DIR . 'main/'.strtolower($m[1]).'.php')){
		include_once(SOCIALFEEDS_PRO_PLUGIN_DIR.'main/'.strtolower($m[1]).'.php');
	}
}

spl_autoload_register('socialfeeds_pro_autoloader');
register_activation_hook(SOCIALFEEDS_PRO_FILE, '\SocialFeedsPro\Install::activate');
register_deactivation_hook(SOCIALFEEDS_PRO_FILE, '\SocialFeedsPro\Install::deactivate');
register_uninstall_hook(SOCIALFEEDS_PRO_FILE, '\SocialFeedsPro\Install::uninstall');
add_action('plugins_loaded', 'socialfeeds_pro_load_plugin');

// Prevent update of socialfeeds free
// This also work for auto update
add_filter('site_transient_update_plugins', 'socialfeeds_pro_disable_manual_update_for_plugin', 20);
add_filter('pre_site_transient_update_plugins', 'socialfeeds_pro_disable_manual_update_for_plugin', 20);

// Auto update free version after update pro version
add_action('upgrader_process_complete', 'socialfeeds_pro_update_free_after_pro', 20, 2);

/**
 * Initialize plugin on plugins_loaded hook
 */
function socialfeeds_pro_load_plugin(){
	global $socialfeeds;

	if(empty($socialfeeds)){
		$socialfeeds = new stdClass();
	}

	socialfeeds_pro_load_license();

	socialfeeds_check_updates();

	include_once(SOCIALFEEDS_PRO_PLUGIN_DIR . 'main/plugin-update-checker.php');
	$socialfeeds_updater = SocialFeeds_PucFactory::buildUpdateChecker(socialfeeds_pro_api_url().'/updates.php?version='.SOCIALFEEDS_PRO_VERSION, SOCIALFEEDS_PRO_FILE);

	if(defined('SOCIALFEEDS_VERSION') && defined('SOCIALFEEDS_FILE')){
		SocialFeeds_PucFactory::buildUpdateChecker(socialfeeds_pro_api_url().'/updates.php?type=free&version='.SOCIALFEEDS_VERSION, SOCIALFEEDS_FILE);
	}

	// Add the license key to query arguments
	$socialfeeds_updater->addQueryArgFilter('socialfeeds_pro_updater_filter_args');

	// Show the text to install the license key
	add_filter('puc_manual_final_check_link-socialfeeds-pro', 'socialfeeds_pro_updater_check_link', 10, 1);

	if(wp_doing_ajax()){
		\SocialFeedsPro\Ajax::hooks();
	}

	\SocialFeedsPro\YouTube::init();
	\SocialFeedsPro\Blocks::init();

	if(is_admin()){
		\SocialFeedsPro\Admin::init();
		return;
	}

	if(!is_admin()){
		add_filter('socialfeeds_allowed_click_actions', '\SocialFeedsPro\Loader::youtube_play_actions');
		add_action('wp_enqueue_scripts', '\SocialFeedsPro\Loader::enqueue_frontend');
	}
}

function socialfeeds_check_updates(){

	$current_version = get_option('socialfeeds_pro_version');
	$version = (int) str_replace('.', '', $current_version);

	// No update required
	if($current_version == SOCIALFEEDS_PRO_VERSION){
		return true;
	}

	// Is it first run ?
	if(empty($current_version)){
		\SocialFeedsPro\Install::activate();
		return;
	}

	update_option('socialfeeds_pro_version', SOCIALFEEDS_PRO_VERSION);
}


