<?php

namespace SocialFeedsPro;

if(!defined('ABSPATH')){
	exit;
}

class ShortcodeRender{

	static function instagram_feed($atts) {
		$options = get_option('socialfeeds_instagram_option', []);
		$atts = shortcode_atts([
			'feed' => '',
			'id' => '',
			'username' => '',
			// default empty so saved settings control limit unless shortcode sets it
			'limit' => '',
			'token' => isset($options['instagram_access_token']) ? $options['instagram_access_token'] : '',
			'type' => isset($options['instagram_default_type']) ? $options['instagram_default_type'] : 'all',
			'align' => '',
			'width' => '',
			'debug' => false,
		], $atts);

		// Load feed-specific settings if feed ID provided
		$feed_settings = [];
		$found_feed = null; 
		if (!empty($atts['feed']) || !empty($atts['id'])) {
			$feeds = isset($options['instagram_feeds']) ? $options['instagram_feeds'] : [];
			$feed_identifier = !empty($atts['feed']) ? $atts['feed'] : $atts['id'];
			
			// 1. Try finding by ID (String comparison)
			foreach ($feeds as $f) {
				if (isset($f['id']) && (string)$f['id'] === (string)$feed_identifier) {
					$found_feed = $f;
					break;
				}
			}

			if ($found_feed) {
				$feed_settings = isset($found_feed['settings']) ? $found_feed['settings'] : [];
				if (empty($atts['username']) && isset($found_feed['input'])) {
					$atts['username'] = $found_feed['input'];
				}
			} else {
				return '<p class="socialfeeds-subtitle">'.esc_html__('Saved feed not found for id ', 'socialfeeds-pro').esc_html($feed_identifier) . esc_html__('.', 'socialfeeds-pro').'</p>';
			}
		}

		// Merge global and feed-specific settings
		$opts = array_merge($options, $feed_settings);
		$show_reels = !empty($opts['instagram_show_reels']);

		$feed_account_token = '';
        if (!empty($atts['feed']) || !empty($atts['id'])) {
            $feeds = isset($options['instagram_feeds']) ? $options['instagram_feeds'] : [];
            $feed_identifier = !empty($atts['feed']) ? $atts['feed'] : $atts['id'];
            foreach ($feeds as $f) {
                if (isset($f['id']) && (string)$f['id'] === (string)$feed_identifier) {
                    $feed_account_token = isset($f['account_token']) ? $f['account_token'] : '';
                    break;
                }
            }
            if (!$feed_account_token && is_numeric($feed_identifier)) {
                $idx = intval($feed_identifier) - 1;
                if (isset($feeds[$idx]['account_token'])) {
                    $feed_account_token = $feeds[$idx]['account_token'];
                }
            }
        }

        $token = !empty($feed_account_token) ? $feed_account_token : (!empty($atts['token']) ? $atts['token'] : (isset($options['instagram_access_token']) ? $options['instagram_access_token'] : ''));
        $username = $atts['username'];
		if (!empty($token) && !empty($username)) {
			$notice = '<p class="socialfeeds-subtitle">' . esc_html__('Note: Access token belongs to a specific Instagram account. To fetch media for "', 'socialfeeds-pro') . esc_html($username) . esc_html__('\" you must provide a token for that account or use the Instagram Business Discovery API.', 'socialfeeds-pro') . '</p>';
		}

		if(!empty($token)){
			$limit = intval($atts['limit']);

			$account_info = \SocialFeedsPro\Util::get_account_info($token);	

			$per_page = 100; 
			if ($limit < 1) {
				$limit = intval(wp_is_mobile() ? 
					(isset($opts['instagram_number_posts_mobile']) ? $opts['instagram_number_posts_mobile'] : 6) : 
					(isset($opts['instagram_number_posts_desktop']) ? $opts['instagram_number_posts_desktop'] : 6)
				);
			}
			$fetch_target = $limit > 0 ? $limit : 100;

			// Fetch paginated posts
			$data = \SocialFeedsPro\Util::fetch_feed_data($token, $fetch_target);
		} elseif (!empty($username)) {
			$try_urls = [
				"https://www.instagram.com/" . rawurlencode($username) . "/?__a=1&__d=dis",
				"https://www.instagram.com/" . rawurlencode($username) . "/?__a=1",
			];
			$data = null;
			foreach ($try_urls as $try) {
				$resp = wp_remote_get($try);
				if (is_wp_error($resp))
					continue;
				$body = wp_remote_retrieve_body($resp);
				$json = json_decode($body, true);
				if (empty($json))
					continue;
				if (!empty($json['graphql']['user']['edge_owner_to_timeline_media']['edges'])) {
					$edges = $json['graphql']['user']['edge_owner_to_timeline_media']['edges'];
					$items = [];
					foreach ($edges as $edge) {
						$node = isset($edge['node']) ? $edge['node'] : null;
						if (!$node)
							continue;
						if (!$show_reels && !empty($node['is_video'])) {
							continue;
						}
						$items[] = [
							'media_type' => !empty($node['is_video']) ? 'VIDEO' : 'IMAGE',
							'media_url' => isset($node['display_url']) ? $node['display_url'] : (isset($node['thumbnail_src']) ? $node['thumbnail_src'] : ''),
							'permalink' => 'https://www.instagram.com/p/' . (isset($node['shortcode']) ? $node['shortcode'] : ''),
							'caption' => isset($node['edge_media_to_caption']['edges'][0]['node']['text']) ? $node['edge_media_to_caption']['edges'][0]['node']['text'] : '',
							'thumbnail_url' => isset($node['thumbnail_src']) ? $node['thumbnail_src'] : '',
						];
					}
					$data = ['data' => $items];
					break;
				}
				if (!empty($json['items'])) {
					$items = [];
					foreach ($json['items'] as $it) {
						$items[] = [
							'media_type' => strtoupper(isset($it['media_type']) ? $it['media_type'] : 'IMAGE'),
							'media_url' => isset($it['image_versions2']['candidates'][0]['url']) ? $it['image_versions2']['candidates'][0]['url'] : (isset($it['carousel_media'][0]['image_versions2']['candidates'][0]['url']) ? $it['carousel_media'][0]['image_versions2']['candidates'][0]['url'] : ''),
							'permalink' => 'https://www.instagram.com/p/' . (isset($it['code']) ? $it['code'] : ''),
							'caption' => isset($it['caption']) ? $it['caption'] : '',
							'thumbnail_url' => isset($it['image_versions2']['candidates'][0]['url']) ? $it['image_versions2']['candidates'][0]['url'] : '',
						];
					}
					$data = ['data' => $items];
					break;
				}
			}

			if (empty($data)) {
				return '<p class="socialfeeds-subtitle">' . esc_html__('Could not fetch public Instagram profile for "', 'socialfeeds-pro') . esc_html($username) . esc_html__('". Instagram may block unauthenticated requests.', 'socialfeeds-pro') . '</p>';
			}

		} else {
			return '<p class="socialfeeds-subtitle">' . esc_html__('Instagram token is missing. Save it in settings or pass `token` attribute, or provide a `username` without token to attempt a public fetch.', 'socialfeeds-pro') . '</p>';
		}

		$width_attr = !empty($atts['width']) ? $atts['width'] : (isset($opts['instagram_width']) ? $opts['instagram_width'] : '');
		$align_attr = !empty($atts['align']) ? $atts['align'] : (isset($opts['instagram_align']) ? $opts['instagram_align'] : '');

		$width_class = !empty($width_attr) ? ' socialfeeds-width-' . str_replace('%', 'pct', esc_attr($width_attr)) : '';
		$align_class = !empty($align_attr) ? ' socialfeeds-align-' . esc_attr($align_attr) : '';

		$layout = isset($opts['instagram_layout']) ? $opts['instagram_layout'] : 'grid';
		$color_scheme = isset($opts['instagram_color_scheme']) ? $opts['instagram_color_scheme'] : 'light';
		$custom_color = isset($opts['instagram_custom_color']) ? $opts['instagram_custom_color'] : '#000000';

		$scheme_class = 'socialfeeds-scheme-' . $color_scheme;
		$scheme_style = '';
		
		// Text Colors
		$text_color = '#1d2327';
		$meta_color = '#606060';

		if($color_scheme === 'dark'){
			$text_color = '#ffffff';
			$meta_color = '#cccccc';
		} elseif($color_scheme === 'custom'){
			$scheme_style = 'background-color:' . esc_attr($custom_color) . ' !important;';
			
			// Calculate brightness
			$hex = str_replace('#', '', $custom_color);
			if(strlen($hex) == 3) {
				$hex = $hex[0].$hex[0].$hex[1].$hex[1].$hex[2].$hex[2];
			}
			$r = hexdec(substr($hex, 0, 2));
			$g = hexdec(substr($hex, 2, 2));
			$b = hexdec(substr($hex, 4, 2));
			$brightness = (($r * 299) + ($g * 587) + ($b * 114)) / 1000;
			
			if($brightness < 128){
				$text_color = '#ffffff';
				$meta_color = '#cccccc';
			}
		}

		// Responsive columns	
		$cols_desktop = intval(isset($opts['instagram_columns_desktop'])? $opts['instagram_columns_desktop']: (isset($opts['instagram_grid_columns'])? $opts['instagram_grid_columns']: 3));	
		$cols_mobile = isset($opts['instagram_columns_mobile']) ? intval($opts['instagram_columns_mobile']) : 1;
		$padding = intval(isset($opts['instagram_padding'])? $opts['instagram_padding']: 16);
		$inner_style = 'gap:' . $padding . 'px;';
		if($layout === 'grid'){
			$inner_style .= ' display: grid; grid-template-columns: repeat(' . $cols_desktop . ', 1fr);';
		} elseif($layout === 'masonry'){
			$inner_style .= ' column-count: ' . $cols_desktop . '; column-gap: ' . $padding . 'px;';
		}

		// Also, add this media query for mobile responsiveness:
		$mobile_style = '';
		if($layout === 'grid'){
			$mobile_style = '<style>@media (max-width: 768px) {.socialfeeds-instagram-inner.layout-grid{grid-template-columns: repeat(' . $cols_mobile . ', 1fr) !important;}}</style>';
		} elseif($layout === 'masonry'){
			$mobile_style = '<style>@media (max-width: 768px) {.socialfeeds-instagram-inner.layout-masonry{column-count: ' . $cols_mobile . ' !important;}}</style>';
		}

		// Header settings
		$header_enabled = !empty($opts['instagram_header_enabled']);
		$header_show_bio = $header_enabled && !empty($opts['instagram_show_bio_text']) && !empty($account_info['biography']);
		$header_show_followers = $header_enabled && !empty($opts['instagram_show_followers']) && !empty($account_info['followers_count']);
		$media_count_enabled = $header_enabled && !empty($opts['instagram_media_count']) && !empty($account_info['media_count']);
		$header_style = isset($opts['instagram_header_style']) ? $opts['instagram_header_style'] : 'standard';
		$header_size_opt = isset($opts['instagram_header_size']) ? $opts['instagram_header_size'] : 'medium';

		switch ($header_size_opt) {
			case 'small': $header_size = 48; break;
			case 'large': $header_size = 96; break;
			case 'medium': default: $header_size = 72; break;
		}

		// Build header HTML
		$header_html = '';
		if($header_enabled && !empty($account_info)){
			$account_name = (isset($account_info['username']) && $account_info['username'] !== '') ? $account_info['username'] : (isset($account_info['name']) ? $account_info['name'] : '');
			$account_bio = isset($account_info['biography']) ? $account_info['biography'] : '';
			$account_followers = isset($account_info['followers_count']) ? number_format_i18n($account_info['followers_count']) : '';
			$account_media_count = isset($account_info['media_count']) ? number_format_i18n($account_info['media_count']) : '';
			$account_avatar = isset($account_info['profile_picture_url']) ? $account_info['profile_picture_url'] : '';
			
			// Custom Avatar Override
			if(!empty($opts['instagram_custom_avatar'])){
				$account_avatar = $opts['instagram_custom_avatar'];
			}

			if(!empty($account_avatar) || !empty($account_name)){
				$header_class = 'socialfeeds-instagram-header socialfeeds-instagram-header-' . esc_attr($header_style);
				
				// Use calculated text color
				$header_html = '<div class="' . $header_class . '" style="color:' . esc_attr($text_color) . ';">';

				if(!empty($account_avatar)){
					$header_html .= '<img src="' . esc_url($account_avatar) . '" alt="' . esc_attr($account_name) . '" class="socialfeeds-instagram-header-avatar" style="width:' . intval($header_size) . 'px; height:' . intval($header_size) . 'px;">';
				}

				$header_html .= '<div class="socialfeeds-instagram-header-info">';
				if (!empty($account_name)) $header_html .= '<h3 class="socialfeeds-instagram-header-name">' . esc_html($account_name) . '</h3>';
				if ($header_show_bio && !empty($account_bio)) $header_html .= '<p class="socialfeeds-instagram-header-bio">' . esc_html($account_bio) . '</p>';
				if ($header_show_followers && !empty($account_followers)) $header_html .= '<p class="socialfeeds-instagram-header-followers"><strong>' . esc_html($account_followers) . '</strong> ' . esc_html__('Followers', 'socialfeeds-pro') . '</p>';
				if ($media_count_enabled && !empty($account_media_count)) $header_html .= '<p class="socialfeeds-instagram-header-followers"><strong>' . esc_html($account_media_count) . '</strong> ' . esc_html__('Posts', 'socialfeeds-pro') . '</p>';
				$header_html .= '</div></div>';
			}
		}

		$play_mode = isset($opts['instagram_play_mode']) ? $opts['instagram_play_mode'] : 'newtab';
		$unique_id = 'socialfeeds-instagram-' . uniqid();

		// Main container
		$html = $mobile_style . '<div id="' . esc_attr($unique_id) . '" class="socialfeeds-instagram-feed ' . $scheme_class . ' ' . $align_class . ' ' . $width_class . '" style="' . $scheme_style . '" data-play-mode="' . esc_attr($play_mode) . '">';
		$html .= $header_html;
		$html .= '<div class="socialfeeds-instagram-inner layout-' . esc_attr($layout) . '" style="' . esc_attr($inner_style) . '">';

		// Posts processing
		$limit = intval($atts['limit']);
		if ($limit < 1) {
			$limit = intval( wp_is_mobile()? (isset($opts['instagram_number_posts_mobile']) ? $opts['instagram_number_posts_mobile'] : (isset($opts['instagram_number_posts_desktop']) ? $opts['instagram_number_posts_desktop'] : 6)) : (isset($opts['instagram_number_posts_desktop']) ? $opts['instagram_number_posts_desktop'] : 6) );
		}
		$sort_by = isset($opts['instagram_sort_by']) ? $opts['instagram_sort_by'] : 'newest';
			if (!empty($data['data'])) {
				$posts_to_display = [];
				$show_feed_posts = isset($opts['instagram_show_feed_posts']) ? !empty($opts['instagram_show_feed_posts']) : true;

				foreach ($data['data'] as $post) {
					$media_type = strtoupper(isset($post['media_type']) ? $post['media_type'] : '');
					$permalink = isset($post['permalink']) ? $post['permalink'] : '';

					// Identify Reel vs Post matches admin.js logic
					$is_reel = ($media_type === 'VIDEO' || $media_type === 'REEL' || strpos($permalink, '/reel/') !== false);
					$is_post = !$is_reel;

					if (!$show_reels && $is_reel) {
						continue;
					}
					if (!$show_feed_posts && $is_post) {
						continue;
					}

					$posts_to_display[] = $post;
				}
			if ($sort_by === 'likes') {
				usort($posts_to_display, function ($a, $b) {
        		$a_likes = isset($a['like_count']) ? intval($a['like_count']) : 0; $b_likes = isset($b['like_count']) ? intval($b['like_count']) : 0;
				return $b_likes - $a_likes; });
			} elseif ($sort_by === 'random') {
				shuffle($posts_to_display);
			} else {
				usort($posts_to_display, function ($a, $b) {
				$a_time = isset($a['timestamp']) ? strtotime($a['timestamp']) : 0; $b_time = isset($b['timestamp']) ? strtotime($b['timestamp']) : 0;
				return $b_time - $a_time;});
			}
			$count = 0;
			$aspect_ratio = isset($opts['instagram_aspect_ratio']) ? $opts['instagram_aspect_ratio'] : 'square';
			$hover_state  = isset($opts['instagram_hover_state'])  ? $opts['instagram_hover_state']  : 'overlay';

			foreach ($posts_to_display as $post) {
				if ($count >= $limit) break;

				$item_style = '';
				if ($layout === 'carousel') {
					$item_width = "calc((100% - " . (($cols_desktop - 1) * $padding) . "px) / " . $cols_desktop . ")";
					$item_style = ' style="flex: 0 0 ' . $item_width . '; max-width: ' . $item_width . ';"';
				} elseif ($layout === 'masonry') {
					$item_style = ' style="margin-bottom: ' . $padding . 'px;"';
				}

				$media_type = strtoupper(isset($post['media_type']) ? $post['media_type'] : 'IMAGE');
				$media_url  = isset($post['media_url']) ? esc_url($post['media_url']) : (isset($post['thumbnail_url']) ? esc_url($post['thumbnail_url']) : '');
				$permalink  = isset($post['permalink']) ? esc_url($post['permalink']) : '#';
				$caption    = isset($post['caption']) ? esc_html($post['caption']) : '';
				
				$item_aspect = ($aspect_ratio === 'instagram') ? (($media_type === 'VIDEO') ? 'portrait' : 'square') : $aspect_ratio;
				if ($layout === 'masonry') $item_aspect = 'auto';

				$html .= '<div class="socialfeeds-instagram-item hover-' . esc_attr($hover_state) . '"' . $item_style . '>';
				$html .= '<div class="socialfeeds-instagram-media aspect-' . $item_aspect . '">';
				
				if ($media_type === 'VIDEO') {
					$poster = esc_url(isset($post['thumbnail_url']) ? $post['thumbnail_url'] : $media_url);
					
					if ($play_mode === 'inline') {
						$html .= '<video class="socialfeeds-video-player" controls preload="metadata" poster="' . esc_attr($poster) . '"><source src="' . $media_url . '" type="video/mp4"></video>';
					} else {
						$click_class = ($play_mode === 'lightbox') ? 'socialfeeds-open-modal-media' : '';
						$target = ($play_mode === 'newtab') ? 'target="_blank" rel="noopener noreferrer"' : '';
						$href = ($play_mode === 'newtab') ? $permalink : '#';
						
						$html .= '<a href="' . $href . '" ' . $target . ' class="' . $click_class . '" data-media="' . $media_url . '" data-type="VIDEO" data-permalink="' . $permalink . '">';
						$html .= '<img src="' . $poster . '" alt="Instagram video">';
						if (!isset($opts['instagram_show_play_icon']) || !empty($opts['instagram_show_play_icon'])) {
							$html .= '<span class="socialfeeds-play-overlay"><span class="dashicons dashicons-arrow-right"></span></span>';
						}
						$html .= '</a>';
					}
				} else {
					$click_class = ($play_mode === 'lightbox') ? 'socialfeeds-open-modal-media' : '';
					$target = ($play_mode === 'newtab' || $play_mode === 'inline') ? 'target="_blank" rel="noopener noreferrer"' : ''; 
					$href = ($play_mode === 'newtab' || $play_mode === 'inline') ? $permalink : '#';

					$html .= '<a href="' . $href . '" ' . $target . ' class="' . $click_class . '" data-media="' . $media_url . '" data-type="IMAGE" data-permalink="' . $permalink . '" rel="noopener"><img src="' . $media_url . '" alt="Instagram post"></a>';
				}

				if ($hover_state === 'overlay') {
					$html .= '<div class="socialfeeds-hover-overlay"></div>';
				}
				$html .= '</div>'; // media

				// Stats
				$html .= '<div class="socialfeeds-instagram-stats">';
				if (!empty($opts['instagram_caption_enabled']) && !empty($caption)) {
					$html .= '<div class="caption">' . $caption . '</div>';
				}
				if (!empty($opts['instagram_likes']) && isset($post['like_count'])) {
					$html .= '<span class="likes"><span class="dashicons dashicons-heart socialfeeds-likes"></span> ' . number_format_i18n($post['like_count']) . '</span>';
				}
				if (!empty($opts['instagram_comments']) && isset($post['comments_count'])) {
					$html .= '<span class="comments"><span class="dashicons dashicons-admin-comments socialfeeds-comments"></span> ' . number_format_i18n($post['comments_count']) . '</span>';
				}
				$html .= '</div>'; // stats
				$html .= '</div>'; // item
				
				$count++;
			}
		}

		$html .= '</div>'; // inner

		// Footer Actions (Load More / Follow)
		$load_more_enabled = !empty($opts['instagram_load_more_enabled']);
		$follow_enabled = !empty($opts['instagram_follow_button_enabled']);

		if ($load_more_enabled || $follow_enabled) {
			$html .= '<div class="socialfeeds-load-more-container socialfeeds-instagram-actions">';
			if ($load_more_enabled) {
				$lm_text  = isset($opts['instagram_load_more_text']) ? $opts['instagram_load_more_text'] : 'Load More';
				$lm_bg    = isset($opts['instagram_load_more_bg_color']) ? $opts['instagram_load_more_bg_color'] : '#f0f0f0';
				$lm_color = isset($opts['instagram_load_more_text_color']) ? $opts['instagram_load_more_text_color'] : '#333333';
				$lm_hover = isset($opts['instagram_load_more_hover_color']) ? $opts['instagram_load_more_hover_color'] : '#fc0909';
				$lm_count = isset($opts['instagram_load_more_count']) ? $opts['instagram_load_more_count'] : 12;
				$html .= '<button type="button" class="socialfeeds-load-more-btn" 
				data-feed-type="instagram" 
				data-next-url="' . (isset($data['paging']['next']) ? esc_attr($data['paging']['next']) : '') . '"
				data-load-count="' . esc_attr($lm_count) . '" 
				data-layout="' . esc_attr($layout) . '" 
				data-padding="' . esc_attr($padding) . '" 
				data-cols="' . esc_attr($cols_desktop) . '" 
				data-aspect-ratio="' . esc_attr($aspect_ratio) . '" 
				data-caption-enabled="' . (!empty($opts['instagram_caption_enabled']) ? '1' : '0') . '"
				data-likes-enabled="' . (!empty($opts['instagram_likes']) ? '1' : '0') . '"
				data-comments-enabled="' . (!empty($opts['instagram_comments']) ? '1' : '0') . '"
				data-views-enabled="' . (!empty($opts['instagram_video_views']) ? '1' : '0') . '"
				data-show-reels="' . ($show_reels ? '1' : '0') . '"
				data-show-feed-posts="' . ($show_feed_posts ? '1' : '0') . '"
				data-hover-state="' . esc_attr($hover_state) . '"
				data-play-mode="' . esc_attr($play_mode) . '"
				data-show-play-icon="' . (!isset($opts['instagram_show_play_icon']) || !empty($opts['instagram_show_play_icon']) ? '1' : '0') . '"
				style="background:' . esc_attr($lm_bg) . '; color:' . esc_attr($lm_color) . ';">'  . esc_html($lm_text) .  '</button>';				}
			if ($follow_enabled) {
				$fl_text = isset($opts['instagram_follow_button_text']) ? $opts['instagram_follow_button_text'] : 'Follow on Instagram';
				$fl_bg = isset($opts['instagram_follow_button_bg_color']) ? $opts['instagram_follow_button_bg_color'] : '#350ae1';
				$fl_color = isset($opts['instagram_follow_button_text_color']) ? $opts['instagram_follow_button_text_color'] : '#FFFFFF';
				$fl_hover = isset($opts['instagram_follow_button_hover_color']) ? $opts['instagram_follow_button_hover_color'] : '#3706e9';
				$ig_username = isset($account_info['username']) ? $account_info['username'] : '';
				$ig_url = $ig_username ? 'https://www.instagram.com/' . $ig_username . '/' : 'https://www.instagram.com/';
				$html .= '<a href="'.esc_url($ig_url).'" target="_blank" class="socialfeeds-follow-btn" style="background:'.esc_attr($fl_bg).'; color:'.esc_attr($fl_color).'; text-decoration:none;">';
				$html .= '<span class="dashicons dashicons-instagram" style="font-size:18px; width:18px; height:18px; line-height:1; margin-right:6px;"></span>' . esc_html($fl_text) . '</a>';
			}
		$html .= '<style>
			#' . esc_attr($unique_id) . ' .socialfeeds-load-more-btn:hover { background: ' . esc_attr($lm_hover) . ' !important; }
			#' . esc_attr($unique_id) . ' .socialfeeds-follow-btn:hover { background: ' . esc_attr($fl_hover) . ' !important; } </style>';
			$html .= '</div>';
		}

		$html .= '</div>'; // feed
		
		// Add Dynamic Styles for Text Colors
		$html .= '<style>
			#' . esc_attr($unique_id) . ' .socialfeeds-instagram-stats { color: ' . esc_attr($text_color) . '; }
			#' . esc_attr($unique_id) . ' .socialfeeds-instagram-stats .caption { color: ' . esc_attr($text_color) . '; }
			#' . esc_attr($unique_id) . ' .socialfeeds-instagram-stats .likes, 
			#' . esc_attr($unique_id) . ' .socialfeeds-instagram-stats .comments { color: ' . esc_attr($meta_color) . '; }
			#' . esc_attr($unique_id) . ' .socialfeeds-instagram-header-name { color: ' . esc_attr($text_color) . ' !important; }
			#' . esc_attr($unique_id) . ' .socialfeeds-instagram-header-bio, 
			#' . esc_attr($unique_id) . ' .socialfeeds-instagram-header-followers { color: ' . esc_attr($meta_color) . ' !important; }
		</style>';

		$html .= '<div id="socialfeeds-modal-root"></div>';
		return $html;
	}
}

