<?php

namespace SocialFeedsPro;

if(!defined('ABSPATH')){
	exit;
}

class Ajax{

	static function hooks(){

		add_action('wp_ajax_socialfeeds_pro_insta_save_settings', '\SocialFeedsPro\Ajax::save_settings');
		add_action('wp_ajax_socialfeeds_pro_validate_instagram_token', '\SocialFeedsPro\Ajax::validate_instagram_token');
		add_action('wp_ajax_socialfeeds_pro_instagram_fetch_posts', '\SocialFeedsPro\Ajax::instagram_fetch_posts');
		add_action('wp_ajax_nopriv_socialfeeds_load_more_instagram', '\SocialFeedsPro\Ajax::load_more_instagram');
		add_action('wp_ajax_socialfeeds_load_more_instagram','\SocialFeedsPro\Ajax::load_more_instagram');
	}

	static function save_settings(){

		check_ajax_referer('socialfeeds_pro_admin_nonce', 'nonce');

		if(!current_user_can('manage_options')){
			wp_send_json_error(__('You do not have required permission to edit this file.', 'socialfeeds-pro'));
		}

		$insta_opts = get_option('socialfeeds_instagram_option', []);

		$insta_settings = get_option('socialfeeds_instagram_settings', []);

		// 1. Instagram Access Token
		if(isset($_POST['instagram_access_token'])){
			$insta_opts['instagram_access_token'] = !empty($_POST['instagram_access_token']) ? sanitize_text_field(wp_unslash($_POST['instagram_access_token'])) : '';
		}

		// 2. Wizard Feed Save
		if (isset($_POST['feed_type'])) {
			$feed_type = sanitize_text_field(wp_unslash($_POST['feed_type']));
			
			$feed_settings = [
				'instagram_layout' => isset($_POST['instagram_layout']) ? sanitize_text_field(wp_unslash($_POST['instagram_layout'])) : 'grid',
				'instagram_aspect_ratio' => isset($_POST['instagram_aspect_ratio']) ? sanitize_text_field(wp_unslash($_POST['instagram_aspect_ratio'])) : 'square',
				'instagram_padding' => isset($_POST['instagram_padding']) ? intval($_POST['instagram_padding']) : 8,
				'instagram_number_posts_desktop' => isset($_POST['instagram_number_posts_desktop']) ? intval($_POST['instagram_number_posts_desktop']) : 12,
				'instagram_number_posts_mobile' => isset($_POST['instagram_number_posts_mobile']) ? intval($_POST['instagram_number_posts_mobile']) : 6,
				'instagram_columns_desktop' => isset($_POST['instagram_columns_desktop']) ? intval($_POST['instagram_columns_desktop']) : 3,
				'instagram_columns_tablet' => isset($_POST['instagram_columns_tablet']) ? intval($_POST['instagram_columns_tablet']) : 2,
				'instagram_columns_mobile' => isset($_POST['instagram_columns_mobile']) ? intval($_POST['instagram_columns_mobile']) : 1,
				'instagram_color_scheme' => isset($_POST['instagram_color_scheme']) ? sanitize_text_field(wp_unslash($_POST['instagram_color_scheme'])) : 'light',
				'instagram_custom_color' => isset($_POST['instagram_custom_color']) ? sanitize_hex_color(wp_unslash($_POST['instagram_custom_color'])) : '#000000',
				'instagram_header_enabled' => isset($_POST['instagram_header_enabled']) ? 1 : 0,
				'instagram_header_size' => isset($_POST['instagram_header_size']) ? sanitize_text_field(wp_unslash($_POST['instagram_header_size'])) : 'medium',
				'instagram_custom_avatar' => isset($_POST['instagram_custom_avatar']) ? esc_url_raw(wp_unslash($_POST['instagram_custom_avatar'])) : '',
				'instagram_show_bio_text' => isset($_POST['instagram_show_bio_text']) ? 1 : 0,
				'instagram_show_followers' => isset($_POST['instagram_show_followers']) ? 1 : 0,
				'instagram_media_count' => isset($_POST['instagram_media_count']) ? 1 : 0,
				'instagram_header_style' => isset($_POST['instagram_header_style']) ? sanitize_text_field(wp_unslash($_POST['instagram_header_style'])) : 'left',
				'instagram_caption_enabled' => isset($_POST['instagram_caption_enabled']) ? 1 : 0,
				'instagram_likes' => !empty($_POST['instagram_likes']) ? 1 : 0,
				'instagram_comments' => !empty($_POST['instagram_comments']) ? 1 : 0,
				'instagram_video_views' => !empty($_POST['instagram_video_views']) ? 1 : 0,
				'instagram_show_feed_posts' => isset($_POST['instagram_show_feed_posts']) ? 1 : 0,
				'instagram_show_reels' => isset($_POST['instagram_show_reels']) ? 1 : 0,
				'instagram_play_mode' => isset($_POST['instagram_play_mode']) ? sanitize_text_field(wp_unslash($_POST['instagram_play_mode'])) : 'newtab',
				'instagram_show_play_icon' => isset($_POST['instagram_show_play_icon']) ? 1 : 0,
				'instagram_hover_state' => isset($_POST['instagram_hover_state']) ? sanitize_text_field(wp_unslash($_POST['instagram_hover_state'])) : 'overlay',
				'instagram_sort_by' => isset($_POST['instagram_sort_by']) ? sanitize_text_field(wp_unslash($_POST['instagram_sort_by'])) : 'newest',
				'instagram_follow_button_enabled' => isset($_POST['instagram_follow_button_enabled']) ? 1 : 0,
				'instagram_follow_button_text' => isset($_POST['instagram_follow_button_text']) ? sanitize_text_field(wp_unslash($_POST['instagram_follow_button_text'])) : 'Follow on Instagram',
				'instagram_follow_button_bg_color' => isset($_POST['instagram_follow_button_bg_color']) ? sanitize_hex_color(wp_unslash($_POST['instagram_follow_button_bg_color'])) : '#00376B',
				'instagram_follow_button_text_color' => isset($_POST['instagram_follow_button_text_color']) ? sanitize_hex_color(wp_unslash($_POST['instagram_follow_button_text_color'])) : '#FFFFFF',
				'instagram_follow_button_hover_color' => isset($_POST['instagram_follow_button_hover_color']) ? sanitize_hex_color(wp_unslash($_POST['instagram_follow_button_hover_color'])) : '#4e0ee4',
				'instagram_load_more_enabled' => isset($_POST['instagram_load_more_enabled']) ? 1 : 0,
				'instagram_load_more_text' => isset($_POST['instagram_load_more_text']) ? sanitize_text_field(wp_unslash($_POST['instagram_load_more_text'])) : 'Load More...',
				'instagram_load_more_bg_color' => isset($_POST['instagram_load_more_bg_color']) ? sanitize_hex_color(wp_unslash($_POST['instagram_load_more_bg_color'])) : '#E74C3C',
				'instagram_load_more_text_color' => isset($_POST['instagram_load_more_text_color']) ? sanitize_hex_color(wp_unslash($_POST['instagram_load_more_text_color'])) : '#FFFFFF',
				'instagram_load_more_hover_color' => isset($_POST['instagram_load_more_hover_color']) ? sanitize_hex_color(wp_unslash($_POST['instagram_load_more_hover_color'])) : '#f76606',
				'instagram_load_more_count' => isset($_POST['instagram_load_more_count']) ? sanitize_text_field(wp_unslash($_POST['instagram_load_more_count'])) : 12,
			];

			$feeds = isset($insta_opts['instagram_feeds']) ? $insta_opts['instagram_feeds'] : [];
			$input_val = '';
			$account_id = '';
			$account_token = '';

			if(isset($_POST['instagram_selected_account'])){
				$selected_account_index = intval(wp_unslash($_POST['instagram_selected_account']));
				$input_val = sanitize_text_field(wp_unslash($_POST['instagram_selected_account']));
				$accounts = isset($insta_opts['instagram_connected_accounts']) ? $insta_opts['instagram_connected_accounts'] : [];
				if (isset($accounts[$selected_account_index])) {
					$account_id = isset($accounts[$selected_account_index]['id']) ? $accounts[$selected_account_index]['id'] : '';
					$account_token = isset($accounts[$selected_account_index]['token']) ? $accounts[$selected_account_index]['token'] : '';
				}
			} elseif(isset($_POST['source_input'])){
				$input_val = sanitize_text_field(wp_unslash($_POST['source_input']));
			}

			if(isset($input_val)){
				$preview = isset($_POST['preview_url']) ? rawurldecode(sanitize_text_field(wp_unslash($_POST['preview_url']))) : '';
				$edit_id = isset($_POST['edit_id']) ? sanitize_text_field(wp_unslash($_POST['edit_id'])) : '';
				
				if ($edit_id) {
					$updated = false;
					foreach($feeds as $k => $f){
						if(isset($f['id']) && (string) $f['id'] === (string) $edit_id){
							$feeds[$k]['settings'] = $feed_settings;
							$feeds[$k]['input'] = $input_val;
							$feeds[$k]['preview'] = $preview;
							$feeds[$k]['account_id'] = $account_id;
							$feeds[$k]['account_token'] = $account_token;
							$updated = true;
							break;
							}
					}
					if(!$updated) $edit_id = '';
				}

				if(!$edit_id){
				$same_type_count = 0;
				foreach($feeds as $f){
					if(isset($f['type']) && $f['type'] === $feed_type) $same_type_count++;
				}
				$index = $same_type_count + 1;
				$name = 'Instagram Feed - ' . ucfirst($feed_type) . ' ' . $index;
				$feed_id = isset($_POST['client_feed_id']) ? sanitize_text_field(wp_unslash($_POST['client_feed_id'])) : '';
				
				if(empty($feed_id)){
					// Get global ID counter
					$global_counter = get_option('socialfeeds_global_id_counter', 0);
					
					// Collect all existing IDs from both YouTube and Instagram
					$all_existing_ids = [];
					
					// Instagram IDs
					foreach ($feeds as $f) {
						if (isset($f['id'])) {
							$all_existing_ids[] = intval($f['id']);
						}
					}
					
					// YouTube IDs
					$youtube_opts = get_option('socialfeeds_youtube_option', []);
					$youtube_feeds = isset($youtube_opts['youtube_feeds']) ? $youtube_opts['youtube_feeds'] : [];
					foreach($youtube_feeds as $f){
						if(isset($f['id'])){
							$all_existing_ids[] = intval($f['id']);
						}
					}
					
					// Find next available ID
					// If no feeds exist, start from 1 and reset counter
					if (empty($all_existing_ids)) {
						$next_id = 1;
						// Reset global counter
						update_option('socialfeeds_global_id_counter', 2);
					} else {
						$next_id = max($global_counter, 1);
						while(in_array($next_id, $all_existing_ids)){
							$next_id++;
						}
						// Update global counter
						update_option('socialfeeds_global_id_counter', $next_id + 1);
					}
					
					$feed_id = $next_id;
				}
				
				$feeds[] = [
					'id' => $feed_id,
					'name' => $name,
					'shortcode' => '[socialfeeds id="' . $feed_id . '" platform="instagram"]',
					'type' => $feed_type,
					'input' => $input_val,
					'preview' => $preview,
					'settings' => $feed_settings,
					'account_id' => $account_id,
					'account_token' => $account_token,
					'created' => time(),	
				];
			}	
				$insta_opts['instagram_feeds'] = $feeds;
			}
		}

		update_option('socialfeeds_instagram_option', $insta_opts);

		$response = ['message' => esc_html__('Settings saved successfully.', 'socialfeeds-pro')];

		wp_send_json_success([
			'message' => esc_html__('Settings saved successfully.', 'socialfeeds-pro'),
			'feed_id' => isset($feed_id) ? $feed_id : $edit_id
		]);

	}

	static function load_more_instagram(){
		check_ajax_referer('socialfeeds_frontend_nonce', 'nonce');

		$next_url = isset($_POST['next_url']) ? esc_url_raw( wp_unslash($_POST['next_url']) )  : '';
		$load_count = isset($_POST['load_count']) ? intval($_POST['load_count']) : 12;
		if (!$next_url) {
			wp_send_json_error('Missing next URL');
		}

		// Security
		$parsed_url = wp_parse_url($next_url);
		if (empty($parsed_url['host']) || $parsed_url['host'] !== 'graph.instagram.com') {
			wp_send_json_error('Invalid URL domain');
		}

		$response = wp_remote_get($next_url);

		if (is_wp_error($response)) {
			wp_send_json_error('Request failed');
		}

		$data = json_decode(wp_remote_retrieve_body($response), true);

		if (empty($data['data'])) {
			wp_send_json_error('No data');
		}

		$show_reels = !isset($_POST['show_reels']) || ($_POST['show_reels'] === '1');
		$show_feed_posts = !isset($_POST['show_feed_posts']) || ($_POST['show_feed_posts'] === '1');

		$valid_data = [];
		foreach ($data['data'] as $post) {
			$media_type = isset($post['media_type']) ? strtoupper($post['media_type']) : 'IMAGE';
			$permalink = isset($post['permalink']) ? $post['permalink'] : '';

			$is_reel = ($media_type === 'VIDEO' || $media_type === 'REEL' || strpos($permalink, '/reel/') !== false);
			$is_post = !$is_reel;

			if (!$show_reels && $is_reel) continue;
			if (!$show_feed_posts && $is_post) continue;

			$valid_data[] = $post;
		}

		$posts_to_load = array_slice($valid_data, 0, $load_count);

		ob_start();

		$layout = isset($_POST['layout']) ? sanitize_text_field(wp_unslash($_POST['layout'])) : 'grid';
		$cols_desktop = isset($_POST['cols']) ? intval($_POST['cols']) : 3;
		$padding = isset($_POST['padding']) ? intval($_POST['padding']) : 0;
		$aspect_ratio = isset($_POST['aspect_ratio']) ? sanitize_text_field(wp_unslash($_POST['aspect_ratio'])) : 'square';

		$caption_enabled = !empty($_POST['caption_enabled']) && $_POST['caption_enabled'] !== '0';
		$likes_enabled = !empty($_POST['likes_enabled']) && $_POST['likes_enabled'] !== '0';
		$comments_enabled = !empty($_POST['comments_enabled']) && $_POST['comments_enabled'] !== '0';
		$views_enabled = !empty($_POST['views_enabled']) && $_POST['views_enabled'] !== '0';
		$hover_state = isset($_POST['hover_state']) ? sanitize_text_field(wp_unslash($_POST['hover_state'])) : 'overlay';
		$play_mode = isset($_POST['play_mode']) ? sanitize_text_field(wp_unslash($_POST['play_mode'])) : 'newtab';
		$show_play_icon = !isset($_POST['show_play_icon']) || ($_POST['show_play_icon'] !== '0');

		foreach ($posts_to_load as $post) {
			$media_type = isset($post['media_type']) ? strtoupper($post['media_type']) : 'IMAGE';
			$media_url = isset($post['media_url']) ? esc_url($post['media_url']) : (isset($post['thumbnail_url']) ? esc_url($post['thumbnail_url']) : '');
			$permalink = isset($post['permalink']) ? esc_url($post['permalink']) : '#';
			$caption = isset($post['caption']) ? esc_html($post['caption']) : '';
			$thumb_url = isset($post['thumbnail_url']) ? esc_url($post['thumbnail_url']) : $media_url;
			$item_style = '';
			if ($layout === 'carousel') {
				// Avoid div by zero
				$cols_d = $cols_desktop > 0 ? $cols_desktop : 3;
				// Same calculation as in shortcoderender
				$item_width = "calc((100% - " . (($cols_d - 1) * $padding) . "px) / " . $cols_d . ")";
				$item_style = ' style="flex: 0 0 ' . $item_width . '; max-width: ' . $item_width . ';"';
			} elseif ($layout === 'masonry') {
				$item_style = ' style="margin-bottom: ' . $padding . 'px;"';
			}

			$item_aspect = ($aspect_ratio === 'instagram') ? (($media_type === 'VIDEO') ? 'portrait' : 'square') : $aspect_ratio;
			if ($layout === 'masonry') $item_aspect = 'auto';

			echo '<div class="socialfeeds-instagram-item hover-' . esc_attr($hover_state) . '" style="' . esc_attr($item_style) . '">';
			echo '  <div class="socialfeeds-instagram-media aspect-' . esc_attr($item_aspect) . '">';
			
			if ($media_type === 'VIDEO') {
				if ($play_mode === 'inline') {
					echo '<video class="socialfeeds-video-player" controls preload="metadata" poster="' . esc_attr($thumb_url) . '"> <source src="' . esc_url($media_url) . '" type="video/mp4"> </video>';

					} else {
					$click_class_attr = ($play_mode === 'lightbox') ? 'socialfeeds-open-modal-media' : '';
					$target_attr = ($play_mode === 'newtab') ? ' target="_blank" rel="noopener noreferrer"' : '';
					$href_attr = ($play_mode === 'newtab') ? $permalink : '#';
					
					echo '<a href="' . esc_url($href_attr) . '"' . ( $play_mode === 'newtab' || $play_mode === 'inline' ? ' target="_blank" rel="noopener noreferrer"' : '' ) . ' class="' . esc_attr($click_class_attr) . '"' . ' data-media="' . esc_url($media_url) . '"'. ' data-type="VIDEO"'. ' data-permalink="' . esc_url($permalink) . '">';
					echo '<img src="' . esc_url($thumb_url) . '" alt="Instagram video">';
					if ($show_play_icon) {
						echo '<span class="socialfeeds-play-overlay"><span class="dashicons dashicons-arrow-right"></span></span>';
					}
					echo '</a>';
				}

			} else {
				
				$click_class_attr = ($play_mode === 'lightbox') ? 'socialfeeds-open-modal-media' : '';
				$target_attr = ($play_mode === 'newtab' || $play_mode === 'inline') ? ' target="_blank" rel="noopener noreferrer"' : '';
				$href_attr = ($play_mode === 'newtab' || $play_mode === 'inline') ? $permalink : '#';

				echo '<a href="' . esc_url($href_attr) . '"'. ( ($play_mode === 'newtab' || $play_mode === 'inline') ? ' target="_blank" rel="noopener noreferrer"' : '' ). ' class="' . esc_attr($click_class_attr) . '"'. ' data-media="' . esc_url($media_url) . '"'. ' data-type="IMAGE"'. ' data-permalink="' . esc_url($permalink) . '">'. '<img src="' . esc_url($media_url) . '" alt="Instagram post">'. '</a>';
				}

			if($hover_state === 'overlay'){
				echo '<div class="socialfeeds-hover-overlay"></div>';
			}
			echo '  </div>'; // media

			// Stats
			echo '<div class="socialfeeds-instagram-stats">';
	
			if ($caption_enabled && !empty($caption)) {
				echo '<div class="caption">' . esc_html($caption) . '</div>';
			}

			if ($likes_enabled && isset($post['like_count'])) {
				echo '<span class="likes">❤️ ' . esc_html( number_format_i18n( $post['like_count'] ) ) . '</span>';
			}

			if ($comments_enabled && isset($post['comments_count'])) {
				echo '<span class="comments">💬 ' . esc_html( number_format_i18n( $post['comments_count'] ) ) . '</span>';
			}

			if ($views_enabled && $media_type === 'VIDEO' && isset($post['video_views'])) {
				echo '<span class="views">👁️ ' . esc_html( number_format_i18n( $post['video_views'] ) ) . '</span>';
			}

			echo '</div>'; // stats

			echo '</div>'; // item
		}

		// Slice next URL if there are more posts left
		$remaining_posts = count($data['data']) - $load_count;
		$next = ($remaining_posts > 0) ? (isset($data['paging']['next']) ? $data['paging']['next'] : null) : null;

		wp_send_json_success([
			'html'  => ob_get_clean(),
			'count' => count($posts_to_load),
			'next'  => $next,
		]);
	}

	static function instagram_fetch_posts(){

		check_ajax_referer('socialfeeds_pro_admin_nonce', 'nonce');

		if(!current_user_can('manage_options')){
			wp_send_json_error(__('You do not have permission.', 'socialfeeds-pro'));
		}

		$feed_type = isset($_POST['feed_type']) ? sanitize_text_field(wp_unslash($_POST['feed_type'])) : '';
		$limit = isset($_POST['limit']) ? intval($_POST['limit']) : '';
		$token = isset($_POST['access_token']) ? sanitize_text_field(wp_unslash($_POST['access_token'])) : '';

		$options = get_option('socialfeeds_instagram_option', []);
		$accounts = isset($options['instagram_connected_accounts']) ? $options['instagram_connected_accounts'] : [];


		if(empty($token) && !empty($options['instagram_access_token'])){
			$token = $options['instagram_access_token'];
		}

		if (isset($_POST['selected_account'])) {
			$selected_index = isset( $_POST['selected_account'] ) ? absint( wp_unslash( $_POST['selected_account'] ) ) : 0;
			if (isset($accounts[$selected_index])) {
				$acct = $accounts[$selected_index];
				$api_id = isset($acct['id']) ? $acct['id'] : '';
				$token = isset($acct['token']) ? $acct['token'] : $token;
			}
		}

		if(empty($token) || empty($feed_type)){
			wp_send_json_error(['message' => 'Missing required data']);
		}

		$posts = \SocialFeedsPro\InstagramSettings::fetch_posts($token, $feed_type, $api_id, $limit);

		$account_info = \SocialFeedsPro\Util::get_account_info($token);

		wp_send_json_success([
			'account' => $account_info,
			'posts'   => $posts,
		]);
	}	

	static function validate_instagram_token(){

		check_ajax_referer('socialfeeds_pro_admin_nonce', 'nonce');

		if(!current_user_can('manage_options')){
			wp_send_json_error(__('You do not have required permission.', 'socialfeeds-pro'));
		}

		$token = isset($_POST['access_token']) ? sanitize_text_field(wp_unslash($_POST['access_token'])) : '';

		if(empty($token)){
			wp_send_json_error(__('Access token is required.', 'socialfeeds-pro'));
		}

		$info = \SocialFeedsPro\InstagramSettings::validate_token($token);

		// validate_token() will already send json error on failure
		if(empty($info) || !is_array($info)){
			wp_send_json_error(__('Invalid Instagram token.', 'socialfeeds-pro'));
		}

		$options = get_option('socialfeeds_instagram_option', []);
		
		if(!is_array($options)){
			$options = [];
		}

		$connected = isset($options['instagram_connected_accounts']) ? $options['instagram_connected_accounts'] : [];

		$found = false;

		foreach($connected as $k => $acct){
			if(isset($acct['id']) && (string) $acct['id'] === (string) $info['id']){
				$connected[$k] = array_merge($acct, [
					'id' => $info['id'],
					'username' => $info['username'],
					'name' => $info['name'],
					'profile_picture_url' => $info['profile_picture_url'],
					'account_type' => $info['account_type'],
					'token' => $token,
				]);
				$found = true;
				break;
			}
		}

		if(!$found){
			$connected[] = [
				'id' => $info['id'],
				'username' => $info['username'],
				'name' => $info['name'],
				'profile_picture_url' => $info['profile_picture_url'],
				'account_type' => $info['account_type'],
				'token' => $token,
			];
		}

		$options['instagram_connected_accounts'] = $connected;
		$options['instagram_access_token'] = $token;
		$options['instagram_account_id'] = $info['id'];

		update_option('socialfeeds_instagram_option', $options);

		wp_send_json_success([
			'message' => esc_html__('Account connected successfully.', 'socialfeeds-pro'),
			'account' => $info,
		]);
	}

}
