<?php

namespace SocialFeedsPro;

if(!defined('ABSPATH')){
	exit;
}

class Admin{

	static function init(){
		
		add_action('admin_menu', '\SocialFeedsPro\Admin::add_menu', 100);
		add_action('admin_enqueue_scripts', '\SocialFeedsPro\Admin::admin_enqueue');
		add_action('admin_footer', '\SocialFeedsPro\Admin::render_modals');
		add_action('socialfeeds_clear_instagram_cache', '\SocialFeedsPro\InstagramSettings::clear_cache');
		add_action('socialfeeds_youtube_feeds', '\SocialFeedsPro\Settings\UI::youtube_feed_type');
		add_action('socialfeeds_video_elements', '\SocialFeedsPro\Settings\UI::youtube_video_elements', 10, 1);
		add_action('socialfeeds_insta_quick_settings', '\SocialFeedsPro\Settings\UI::instagram_dashbord_settings');
		add_action('socialfeeds_render_license_page', '\SocialFeedsPro\Settings\License::template');
		add_action('socialfeeds_pro_youtube_layouts', 'SocialFeedsPro\Settings\UI::youtube_layouts', 10, 1);
	}

	static function add_menu(){
		add_submenu_page('socialfeeds', __('License', 'socialfeeds-pro'), __('License', 'socialfeeds-pro'), 'manage_options', 'socialfeeds-license', '\SocialFeedsPro\Admin::dispatcher');
	}

	static function dispatcher(){
		echo '<div class="socialfeeds-wrap">';

		// Render global header
		\SocialFeeds\Admin::render_header();

		echo '<div class="socialfeeds-main-content">';
		echo '<div id="socialfeeds-license" class="socialfeeds-tab-content active">';
			\SocialFeedsPro\Settings\License::template();
		echo '</div>';
		
		echo '</div>'; // socialfeeds-main-content
		echo '</div>'; // socialfeeds-wrap
	}
	
	static function admin_enqueue($hook){
		if(false === strpos($hook, 'socialfeeds')){
			return;
		}
		
		$instagram_options = get_option('socialfeeds_instagram_option', []);
		$instagram_access_token = !empty($instagram_options['instagram_access_token']) ? $instagram_options['instagram_access_token'] : '';
		$instagram_has_accounts = !empty($instagram_options['instagram_connected_accounts']) ? true : false;

		wp_enqueue_style('socialfeeds-pro-admin', SOCIALFEEDS_PRO_PLUGIN_URL.'assets/css/admin.css', [], SOCIALFEEDS_PRO_VERSION);

		wp_enqueue_script('socialfeeds-pro-admin', SOCIALFEEDS_PRO_PLUGIN_URL.'assets/js/admin.js', ['jquery'], SOCIALFEEDS_PRO_VERSION, true);
		
		wp_localize_script('socialfeeds-pro-admin', 'socialfeeds_pro', [
			'nonce' => wp_create_nonce('socialfeeds_pro_admin_nonce'),
			'ajax_url' => admin_url('admin-ajax.php'),
			'admin_page_url' => admin_url('admin.php?page=socialfeeds'),
		]);
	}

	static function render_instagram_settings(){
		\SocialFeedsPro\Settings\UI::instagram_connect_screen();
	}

	static function render_modals(){
		if(!is_admin()){
			return;
		}
		
		$screen = get_current_screen();
		if(empty($screen) || strpos($screen->id, 'socialfeeds') === false){
			return;
		}

		$youtube_opts = get_option('socialfeeds_youtube_option', []);
		$insta_opts = get_option('socialfeeds_instagram_option', []);

		echo'<div id="socialfeeds-ig-connection-modal" class="socialfeeds-modal-overlay">
			<div class="socialfeeds-modal-content">
				<button type="button" class="socialfeeds-modal-close" data-modal="socialfeeds-ig-connection-modal">&times;</button>
				<h2>'.esc_html__('Instagram Settings', 'socialfeeds-pro').'</h2>
				<p>'.esc_html__('Configure your Access Token and create feeds', 'socialfeeds-pro').'</p>

				<form id="socialfeeds-ig-modal-token-form" method="post">
					<div class="socialfeeds-modal-form-group">
						<label for="socialfeeds-modal-ig-token">'. esc_html__('Instagram Access Token', 'socialfeeds-pro') .'</label>';
						// Mask existing token for security
						$existing_token = isset($insta_opts['instagram_access_token']) ? $insta_opts['instagram_access_token'] : '';
						$masked_token = $existing_token ? str_repeat('•', 20) . substr($existing_token, -8) : '';
					echo '	<input name="instagram_access_token" type="text" id="socialfeeds-modal-ig-token" value="'. esc_attr($masked_token) .'" class="regular-text socialfeeds-api-input" placeholder="'. esc_attr__('Enter your Instagram Access Token', 'socialfeeds-pro') .'" data-has-token="' . ($existing_token ? 'true' : 'false') . '" />
						<p class="description">'.esc_html__('Enter a long-lived Instagram Access Token', 'socialfeeds-pro') . ($existing_token ? ' ' . esc_html__('(Token is saved and masked for security)', 'socialfeeds-pro') : '') .'</p>
					</div>

					<div class="socialfeeds-modal-actions">
						<button type="submit" class="button socialfeeds-modal-btn-purple">'. esc_html__('Save Token', 'socialfeeds-pro') .'</button>
						<button type="button" id="socialfeeds-add-new-feed" class="button">'. esc_html__('+ Add New Feed', 'socialfeeds-pro').'</button>
						</div>
				</form>
			</div>
		</div>';

	}
}
